/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.engine_room.flywheel.api.backend.Backend;
import dev.engine_room.flywheel.api.backend.BackendManager;
import dev.engine_room.flywheel.backend.BackendDebugFlags;
import dev.engine_room.flywheel.backend.compile.LightSmoothness;
import dev.engine_room.flywheel.backend.compile.PipelineCompiler;
import dev.engine_room.flywheel.backend.engine.uniform.DebugMode;
import dev.engine_room.flywheel.backend.engine.uniform.FrameUniforms;
import dev.engine_room.flywheel.impl.BackendArgument;
import dev.engine_room.flywheel.impl.DebugModeArgument;
import dev.engine_room.flywheel.impl.FabricFlwConfig;
import dev.engine_room.flywheel.impl.FlwDebugInfo;
import dev.engine_room.flywheel.impl.ImplDebugFlags;
import dev.engine_room.flywheel.impl.LightSmoothnessArgument;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_2262;
import net.minecraft.class_2267;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7157;

public final class FlwCommands {
    private FlwCommands() {
    }

    public static void registerClientCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 buildContext) {
        LiteralArgumentBuilder command = ClientCommandManager.literal((String)"flywheel");
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"backend").executes(context -> {
            Backend backend = BackendManager.currentBackend();
            String idStr = Backend.REGISTRY.getIdOrThrow(backend).toString();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"command.flywheel.backend.get", (Object[])new Object[]{idStr}));
            return 1;
        })).then(ClientCommandManager.literal((String)"DEFAULT").executes(context -> {
            FabricFlwConfig.INSTANCE.backend = BackendManager.offBackend();
            FabricFlwConfig.INSTANCE.useDefaultBackend = true;
            FabricFlwConfig.INSTANCE.save();
            class_310.method_1551().field_1769.method_3279();
            Backend actualBackend = BackendManager.currentBackend();
            String actualIdStr = Backend.REGISTRY.getIdOrThrow(actualBackend).toString();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"command.flywheel.backend.set", (Object[])new Object[]{actualIdStr}));
            return 1;
        }))).then(ClientCommandManager.argument((String)"id", (ArgumentType)BackendArgument.INSTANCE).executes(context -> {
            Backend requestedBackend;
            FabricFlwConfig.INSTANCE.backend = requestedBackend = (Backend)context.getArgument("id", Backend.class);
            FabricFlwConfig.INSTANCE.useDefaultBackend = false;
            FabricFlwConfig.INSTANCE.save();
            class_310.method_1551().field_1769.method_3279();
            Backend actualBackend = BackendManager.currentBackend();
            if (actualBackend != requestedBackend) {
                String requestedIdStr = Backend.REGISTRY.getIdOrThrow(requestedBackend).toString();
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43469((String)"command.flywheel.backend.set.unavailable", (Object[])new Object[]{requestedIdStr}));
            }
            String actualIdStr = Backend.REGISTRY.getIdOrThrow(actualBackend).toString();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"command.flywheel.backend.set", (Object[])new Object[]{actualIdStr}));
            return 1;
        })));
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"limitUpdates").executes(context -> {
            if (FabricFlwConfig.INSTANCE.limitUpdates) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"command.flywheel.limit_updates.get.on"));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"command.flywheel.limit_updates.get.off"));
            }
            return 1;
        })).then(ClientCommandManager.literal((String)"on").executes(context -> {
            FabricFlwConfig.INSTANCE.limitUpdates = true;
            FabricFlwConfig.INSTANCE.save();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"command.flywheel.limit_updates.set.on"));
            class_310.method_1551().field_1769.method_3279();
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(context -> {
            FabricFlwConfig.INSTANCE.limitUpdates = false;
            FabricFlwConfig.INSTANCE.save();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"command.flywheel.limit_updates.set.off"));
            class_310.method_1551().field_1769.method_3279();
            return 1;
        })));
        command.then(ClientCommandManager.literal((String)"lightSmoothness").then(ClientCommandManager.argument((String)"mode", (ArgumentType)LightSmoothnessArgument.INSTANCE).executes(context -> {
            LightSmoothness oldValue = FabricFlwConfig.INSTANCE.backendConfig.lightSmoothness;
            LightSmoothness newValue = (LightSmoothness)((Object)((Object)context.getArgument("mode", LightSmoothness.class)));
            if (oldValue != newValue) {
                FabricFlwConfig.INSTANCE.backendConfig.lightSmoothness = newValue;
                FabricFlwConfig.INSTANCE.save();
                PipelineCompiler.deleteAll();
            }
            return 1;
        })));
        command.then(FlwCommands.createDebugCommand());
        dispatcher.register(command);
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> createDebugCommand() {
        LiteralArgumentBuilder debug = ClientCommandManager.literal((String)"debug");
        debug.then(ClientCommandManager.literal((String)"crumbling").then(ClientCommandManager.argument((String)"pos", (ArgumentType)class_2262.method_9698()).then(ClientCommandManager.argument((String)"stage", (ArgumentType)IntegerArgumentType.integer((int)0, (int)9)).executes(context -> {
            class_1297 executor = ((FabricClientCommandSource)context.getSource()).getEntity();
            if (executor == null) {
                return 0;
            }
            class_2338 pos = FlwCommands.getBlockPos((CommandContext<FabricClientCommandSource>)context, "pos");
            int value = IntegerArgumentType.getInteger((CommandContext)context, (String)"stage");
            executor.method_37908().method_8517(executor.method_5628(), pos, value);
            return 1;
        }))));
        debug.then(ClientCommandManager.literal((String)"shader").then(ClientCommandManager.argument((String)"mode", (ArgumentType)DebugModeArgument.INSTANCE).executes(context -> {
            DebugMode mode = (DebugMode)((Object)((Object)context.getArgument("mode", DebugMode.class)));
            FrameUniforms.debugMode(mode);
            return 1;
        })));
        debug.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"frustum").then(ClientCommandManager.literal((String)"capture").executes(context -> {
            FrameUniforms.captureFrustum();
            return 1;
        }))).then(ClientCommandManager.literal((String)"unpause").executes(context -> {
            FrameUniforms.unpauseFrustum();
            return 1;
        })));
        debug.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"lightSections").then(ClientCommandManager.literal((String)"on").executes(context -> {
            BackendDebugFlags.LIGHT_STORAGE_VIEW = true;
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(context -> {
            BackendDebugFlags.LIGHT_STORAGE_VIEW = false;
            return 1;
        })));
        debug.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pauseUpdates").then(ClientCommandManager.literal((String)"on").executes(context -> {
            ImplDebugFlags.PAUSE_UPDATES = true;
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(context -> {
            ImplDebugFlags.PAUSE_UPDATES = false;
            return 1;
        })));
        debug.then(ClientCommandManager.literal((String)"info").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback(FlwDebugInfo.getDebugCommandInfo());
            return 1;
        }));
        return debug;
    }

    private static class_2338 getBlockPos(CommandContext<FabricClientCommandSource> context, String name) {
        return ((class_2267)context.getArgument(name, class_2267.class)).method_9704(((FabricClientCommandSource)context.getSource()).getPlayer().method_5671());
    }
}

